/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl;

import com.ibm.hwmca.fw.util.FastStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.Iterator;

public class StackedInputStream
extends InputStream {
    public static final String TRACE_MASK = "XPMISTI";
    FastStack streamStack = new FastStack();

    public StackedInputStream() {
    }

    public StackedInputStream(InputStream initialStream) {
        this.push(initialStream);
    }

    public void push(InputStream newStream) {
        this.streamStack.push(newStream);
    }

    public void append(InputStream newStream) {
        this.streamStack.add(newStream);
    }

    private InputStream getStream() {
        try {
            return (InputStream)this.streamStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public int read() throws IOException {
        InputStream stream = this.getStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read();
        if (read == -1) {
            stream.close();
            this.streamStack.pop();
            return this.read();
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        InputStream stream = this.getStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read(b, off, len);
        if (read == -1) {
            stream.close();
            this.streamStack.pop();
            return this.read(b, off, len);
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        InputStream stream = this.getStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read(b);
        if (read == -1) {
            stream.close();
            this.streamStack.pop();
            return this.read(b);
        }
        return read;
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("This class does not support reset() and mark()");
    }

    public long skip(long n) throws IOException {
        InputStream stream = this.getStream();
        if (stream == null) {
            return -1L;
        }
        long skipped = stream.skip(n);
        if (skipped == -1L) {
            stream.close();
            this.streamStack.pop();
            return this.skip(n);
        }
        return skipped;
    }

    public int available() throws IOException {
        int count = 0;
        Iterator iterator = this.streamStack.iterator();
        while (iterator.hasNext()) {
            count += ((InputStream)iterator.next()).available();
        }
        return count;
    }

    public void close() throws IOException {
        try {
            while (true) {
                ((InputStream)this.streamStack.pop()).close();
            }
        }
        catch (EmptyStackException e) {
            return;
        }
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("This class does not support reset() and mark()");
    }

    public boolean markSupported() {
        return false;
    }
}

